
function Trim( p_string ) {
	if (typeof p_string != "string") {
		return p_string;
	}

	var t_string = p_string;
	var t_ch = '';

	// Trim beginning spaces

	t_ch = t_string.substring( 0, 1 );
	while ( t_ch == " " ) {
		t_string = t_string.substring( 1, t_string.length );
		t_ch = t_string.substring( 0, 1 );
	}

	// Trim trailing spaces

	t_ch = t_string.substring( t_string.length-1, t_string.length );
	while ( t_ch == " " ) {
		t_string = t_string.substring( 0, t_string.length-1 );
		t_ch = t_string.substring( t_string.length-1, t_string.length );
	}

	return t_string;
}


/*
 * Cookie functions
 */

function GetCookie( p_cookie ) {
	var t_cookie_name = "HB_" + p_cookie;
	var t_cookies = document.cookie;

	t_cookies = t_cookies.split( ";" );

	var i = 0;
	while( i < t_cookies.length ) {
		var t_cookie = t_cookies[ i ];

		t_cookie = t_cookie.split( "=" );

		if ( Trim( t_cookie[ 0 ] ) == t_cookie_name ) {
			return( t_cookie[ 1 ] );
		}
		i++;
	}

	return -1;
}

function SetCookie( p_cookie, p_value ) {
	var t_cookie_name = "HB_" + p_cookie;
	var t_expires = new Date();

	t_expires.setTime( t_expires.getTime() + (365 * 24 * 60 * 60 * 1000));

	document.cookie = t_cookie_name + "=" + p_value + "; expires=" + t_expires + ";";
}


/*
 * Collapsible element functions
 */


///////////////////////////////////

var g_div_admin_form        	= 0x0001;
var g_div_aboutus_form      	= 0x0002;
var g_div_contactus_form		= 0x0010;
var g_div_privacypolicy_form	= 0x0020;
var g_div_faq_form				= 0x0040;




////////////////////
/*
var g_div_coupons_form	= 0x0001;
var g_div_module_form		= 0x0002;
var g_div_database_form	= 0x0004;
var g_div_catalog_form	= 0x0010;
var g_div_system_form	= 0x0020;
var g_div_tool_form 	= 0x0040;
var g_div_customers_form	= 0x0080;
var g_div_statistic_form        = 0x0100;
var g_div_config_form        = 0x0120;
var g_div_abc_form        = 0x0140;
*/

function GetViewSettings() {
	var t_cookie = GetCookie( "VIEW_SETTINGS" );

	if ( -1 == t_cookie ) {
		t_cookie = 0xffff;
	} else {
		t_cookie = parseInt( t_cookie );
	}

	return t_cookie;
}

function SetDiv( p_div, p_cookie_bit ) {
	var t_view_settings = GetViewSettings();

	if( t_view_settings & p_cookie_bit ) {
		document.getElementById( p_div + "_open" ).style.display = "none";
		document.getElementById( p_div + "_closed" ).style.display = "";
	} else {
		document.getElementById( p_div + "_open" ).style.display = "";
		document.getElementById( p_div + "_closed" ).style.display = "none";
	}
}

function ToggleDiv( p_div, p_cookie_bit ) {
	var t_view_settings = GetViewSettings();

	t_view_settings ^= p_cookie_bit;
	SetCookie( "VIEW_SETTINGS", t_view_settings );

	SetDiv( p_div, p_cookie_bit );
}

